package elaprendiz.estructuras.funciones;

import elaprendiz.graficos.funciones.Funcion;

import java.awt.Point;



import elaprendiz.estructuras.nodos.ArbolNodo;

public class MoveNode extends Funcion {

  boolean izquierdaSuperior  = false;
  boolean derechaSuperior = false;
  boolean izquierdaInferior  = false;
  boolean derechaInferior = false;

  ArbolNodo moverNodo = null;

  int limiteX;
  int limiteY;

  int moverX;
  int moverY;

  int movimientoTotalX = 0;
  int movimientoTotalY = 0;

  public MoveNode(Point point, ArbolNodo node) {
    moverNodo = node;

    Point testPoint = node.origin();

    int xCurr = testPoint.x;
    int yCurr = testPoint.y;

    limiteX = (int) Math.abs((double) (point.x - xCurr));
    limiteY = (int) Math.abs((double) (point.y - yCurr));

    moverX = (int) Math.ceil((double) (limiteX / 10));
    moverY = (int) Math.ceil((double) (limiteY / 10));

    if ( (xCurr > point.x) && (yCurr > point.y))
      derechaInferior = true;
    else if (xCurr > point.x)
      derechaSuperior = true;
    else if ( (xCurr < point.x) && (yCurr > point.y))
      izquierdaInferior  = true;
    else
      izquierdaSuperior  = true;
  }

  public void performFuncion() {
    if ( (movimientoTotalX == limiteX) && (movimientoTotalY == limiteY)) {

      ////////////////////////////////////////
      // Notify any observers that the func-
      // tion is terminado.

      setChanged();
      notifyObservers();

      terminado = true;

    }

    else {

      if (derechaInferior)
	moverNodo.translateNode(-moverX, -moverY);
      else if (derechaSuperior)
	moverNodo.translateNode(-moverX, moverY);
      else if (izquierdaInferior)
	moverNodo.translateNode(moverX, -moverY);
      else
	moverNodo.translateNode(moverX, moverY);

      movimientoTotalX += moverX;
      movimientoTotalY += moverY;

      moverX = ( (limiteX - movimientoTotalX) < moverX) ? limiteX - movimientoTotalX: moverX;
      moverY = ( (limiteY - movimientoTotalY) < moverY) ? limiteY - movimientoTotalY: moverY;
    }
  }
}
